package cn.com.duiba.sso.api.config;

import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.HashMap;
import java.util.Map;

public class SsoWebEnvApplicationInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {
    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {

        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        Map<String, Object> map = new HashMap<>();

        Boolean enable = environment.getProperty("duiba.security.csrf.enable",Boolean.class,true);
        map.put("duiba.security.csrf.enable",enable);//启动csrf检测

        PropertySource<?> propertySource = new MapPropertySource("ssoWebConfig",map);
        //最后的优先级最低
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addLast(propertySource);

        ApplicationContext parent = applicationContext.getParent();
        if (parent != null) {
            parent.publishEvent(new EnvironmentChangeEvent(map.keySet()));
        }
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
