package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.enums.SystemSwitches;
import cn.com.duiba.sso.api.service.SsoUrlService;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.PcHandler;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;

/**
 * Created by liuyao on 2017/5/11.
 * 单点登录拦截系统
 */
@PcHandler
public class LoginFilterHandler extends AbstractLoginFilterHandler {

    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private SsoUrlService ssoUrlService;

    @Override
    public Boolean before(Object handler) {


        String ticket = RequestTool.findTicket();
        if(StringUtils.isBlank(ticket)){
            returnNotLogin();
            return false;
        }

        AdminDto admin = verifyTicket(ticket);
        if(admin==null){
            returnNotLogin();
            return false;
        }

        SystemDto system = SystemInfo.getThisSystemInfo();
        if(admin.getModelAuthorize() && !system.switchIsOpen(SystemSwitches.CAN_MOBILE_TO_PC)){
            returnNotLogin();
            return false;
        }


        //注入adminId
        RequestTool.setAdmin(admin);
        return true;
    }

    /**
     * 获取登录重定向地址
     */
    @Override
    protected String getLoginRedirectUrl(){

        String redirect = getCurrentRedirect();
        StringBuilder builder = new StringBuilder();
        String loginUrl = ssoUrlService.getSsoHomeUrl() + "/login";
        builder.append(loginUrl).append("?redirect=").append(redirect);
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    @Override
    protected String getDefaultRedirectUrl(){
        return ssoProperties.getDefaultRedirectUrl();
    }


}
