package cn.com.duiba.sso.api.service;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.system.EnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import javax.annotation.Resource;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Optional;


@Slf4j
public class SsoUrlService {

    private static final String SSO_SERVER_NAME = "sso-service";

    @Resource
    private SsoSystemService ssoSystemService;
    @Resource
    private HostEnvironmentMapping hostEnvironmentMapping;
    @Resource
    private EnvironmentDecisionMaker environmentDecisionMaker;

    public String getSsoHomeUrl(){

        EnvironmentEnum environment = environmentDecisionMaker.getEnvironmentEnum();
        String ssoUrl = null;
        if(StringUtils.equals(SSO_SERVER_NAME,SystemInfo.getSystemAlias())){
            ssoUrl = RequestTool.getRequest().getScheme() +"://"+ hostEnvironmentMapping.findHostByEnvironment(environment);
        }
        return Optional.ofNullable(ssoUrl).orElse(ssoSystemService.getSystemByAlias(SSO_SERVER_NAME).getHomeUrl());
    }

    /**
     * 构建Oauth2请求地址
     * @param url
     * @return
     */
    public String buildOauth2Url(String url){

        try{
            String redirect = URLEncoder.encode(url,"utf-8");
            String state = UUIDUtils.createSecureUUID();

            Map<String,String> params = Maps.newHashMap();
            params.put("redirect",redirect);
            params.put("state",state);

            return UrlUtils.appendParams(getSsoHomeUrl()+"/sso/oauth2/authorize",params);

        }catch (Exception e){
            log.error("构建Oauth2请求地址失败",e);
            throw new SsoRunTimeException(e);
        }

    }
}
