package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.SsoUrlService;
import cn.com.duiba.sso.api.service.system.EnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.service.HostEnvironment;
import cn.com.duiba.sso.api.service.HostEnvironmentMapping;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginSuccessEvent;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/sso")
public class SsoController {

    private static Logger logger = LoggerFactory.getLogger(AuthController.class);

    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private SsoProperties properties;
    @Resource
    private SsoUrlService ssoUrlService;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private EnvironmentDecisionMaker environmentDecisionMaker;

    @CanAccess
    @RequestMapping("/ssoIndex")
    public void ssoIndex(@RequestParam Long ssoStamp,@RequestParam(required = false) String redirect) throws IOException {

        HttpServletResponse response = RequestTool.getResponse();
        try{
            redirect = fixRedirect(redirect);
            Long systemId = SystemInfo.getThisSystemId();
            String ticket = remoteSSOService.findTicketByStamp(systemId,ssoStamp);
            CookieUtil.setCookie(CookieUtil.LOGIN_COOKIE_NAME,ticket);

            AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if(admin==null){
                throw new SsoException("ticket失效");
            }
            LoginSuccessEvent event = new LoginSuccessEvent();
            event.setSession(admin);
            event.setRequest(RequestTool.getRequest());
            event.setResponse(RequestTool.getResponse());
            event.setExpirationTime(CookieUtil.COOKIE_TIME_OUT);
            applicationContext.publishEvent(event);

            String url = Optional.ofNullable(redirect).orElse(properties.getDefaultRedirectUrl());

            response.sendRedirect(url);
        }catch (Exception e){
            logger.debug("跳转登录失败",e);
            response.getWriter().write("跳转登录失败");
        }
    }


    /**
     * 当前的系统信息
     */
    @CanAccess
    @ResponseBody
    @RequestMapping(value = "/systemInfo")
    public JsonRender systemInfo(){

        JsonRender render = JsonRender.successResult();
        render.put("ssoHomeURL",ssoUrlService.getSsoHomeUrl());
        SystemDto systemDto = SystemInfo.getThisSystemInfo();
        render.put("system",systemDto);
        render.put("environment",environmentDecisionMaker.getEnvironmentEnum().getName());

        return render;
    }

    private String fixRedirect(String url){
        if(StringUtils.isBlank(url)){
            return url;
        }
        return StringEscapeUtils.unescapeHtml3(url);
    }

    @ResponseBody
    @RequestMapping(value = "/outLogin")
    public JsonRender outLogin(){
        RequestTool.outLogin();
        return JsonRender.successResult();
    }

}
