package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.service.SsoUrlService;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.service.HostEnvironmentMapping;
import cn.com.duiba.sso.api.web.interceptor.MobileInterceptor;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.api.web.interceptor.annotation.MobileHandler;
import cn.com.duiba.sso.api.web.interceptor.annotation.PcHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.AuthorityFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.LoginFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.MobileLoginFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.SystemFilterHandler;
import cn.com.duiba.sso.api.web.logger.DefaultSsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.*;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

@Configuration
@ComponentScan("cn.com.duiba.sso.api.web")
@ConditionalOnWebApplication
@AutoConfigureAfter(SsoBasicConfiguration.class)
@EnableConfigurationProperties(SsoProperties.class)
@Import({SsoBasicConfiguration.class})//引入SSO基础配置
@Order(-1)
public class SsoAutoConfiguration extends WebMvcConfigurerAdapter implements ApplicationContextAware {

    @Resource
    private SsoProperties ssoProperties;

    private ApplicationContext applicationContext;

    /**
     * 初始化RequestTool
     */
    @Bean
    public RequestTool initRequestTool(){
        return new RequestTool();
    }

    @Bean
    public HostEnvironmentMapping hostEnvironmentMapping(){
        return new HostEnvironmentMapping();
    }

    @Bean
    public SsoUrlService ssoUrlService(){
        return new SsoUrlService();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = ssoProperties.getPathPatterns();
        String[] paths = StringUtils.split(pathPatterns,",");

        String excludePathPatterns = ssoProperties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{} : StringUtils.split(excludePathPatterns,",");

        String mobilePathPatterns = ssoProperties.getMobilePathPatterns();
        String[] mobilePaths = StringUtils.split(mobilePathPatterns,",");

        SsoInterceptor ssoInterceptor = applicationContext.getBean(SsoInterceptor.class);
        registry.addInterceptor(ssoInterceptor)
                .addPathPatterns(paths)
                .addPathPatterns("/auth/**")
                .addPathPatterns("/sso/**")//sso内置开放接口
                .excludePathPatterns(excludePath)
                .excludePathPatterns(mobilePaths);//排除移动端的链接
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoInterceptor ssoInterceptor(List<SsoFilterHandler> ssoFilterHandlers){
        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        SsoInterceptor ssoInterceptor = new SsoInterceptor();
        for (SsoFilterHandler handler:ssoFilterHandlers) {
            PcHandler pcHandler = AnnotationUtils.findAnnotation(handler.getClass(),PcHandler.class);
            if(!Objects.equals(null, pcHandler)){
                queue.addHandler(handler);
            }
        }
        ssoInterceptor.setHandleQueue(queue);
        return ssoInterceptor;
    }


    @Configuration
    @ConditionalOnProperty(name="duiba.sso.mobile-enable", havingValue="true")
    public class SsoMobileConfiguration extends WebMvcConfigurerAdapter{


        @Bean
        public SsoFilterHandler mobileLoginFilterHandler(){
            return new MobileLoginFilterHandler();
        }

        @Override
        public void addInterceptors(InterceptorRegistry registry) {

            String pathPatterns = ssoProperties.getPathPatterns();
            String[] paths = StringUtils.split(pathPatterns,",");

            String mobilePathPatterns = ssoProperties.getMobilePathPatterns();
            String[] mobilePaths = StringUtils.split(mobilePathPatterns,",");

            String excludePathPatterns = ssoProperties.getExcludePathPatterns();
            String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{} : StringUtils.split(excludePathPatterns,",");

            MobileInterceptor mobileInterceptor = applicationContext.getBean(MobileInterceptor.class);
            InterceptorRegistration mobileRegistration = registry.addInterceptor(mobileInterceptor)
                    .addPathPatterns(mobilePaths)
                    .excludePathPatterns(excludePath);

            //移动端将PC端
            if(!StringUtils.equals(pathPatterns,"/**")){
                mobileRegistration.excludePathPatterns(paths);
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public MobileInterceptor mobileInterceptor(List<SsoFilterHandler> ssoFilterHandlers){

            SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
            MobileInterceptor mobileInterceptor = new MobileInterceptor();
            for (SsoFilterHandler handler:ssoFilterHandlers) {
                MobileHandler mobileHandler = AnnotationUtils.findAnnotation(handler.getClass(),MobileHandler.class);
                if(!Objects.equals(null,mobileHandler)){
                    queue.addHandler(handler);
                }
            }
            mobileInterceptor.setHandleQueue(queue);
            return mobileInterceptor;
        }
    }

    @Bean
    public AdminPowerCacheService adminPowerCacheService(){
        return new AdminPowerCacheService();
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter(){
        return new DefaultSsoLoggerMateInfoAdapter();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public SsoFilterHandler loginFilterHandler(){
        return new LoginFilterHandler();
    }

    @Bean
    public SsoFilterHandler systemFilterHandler(){
        return new SystemFilterHandler();
    }

    @Bean
    public SsoFilterHandler authorityFilterHandler(){
        return new AuthorityFilterHandler();
    }


}
