package cn.com.duiba.sso.api.web.interceptor;

import cn.com.duiba.sso.api.constants.SsoConstants;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.service.system.DefaultEnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.service.HostEnvironmentMapping;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.util.Set;

public class AbstractInterceptor extends HandlerInterceptorAdapter {

    private SsoFilterHandlerQueue queue;

    static final Set<String> EXCLUDE_PATHS = Sets.newHashSet();
    @Resource
    private HostEnvironmentMapping hostEnvironmentMapping;
    @Resource
    private DefaultEnvironmentDecisionMaker defaultEnvironmentDecisionMaker;

    static {
        EXCLUDE_PATHS.add("/favicon.ico");
        EXCLUDE_PATHS.add("/monitor/check");
        EXCLUDE_PATHS.add("/swagger-ui.html");
        EXCLUDE_PATHS.add("/swagger-resources");
        EXCLUDE_PATHS.add("/swagger-resources/configuration/ui");
        EXCLUDE_PATHS.add("/v2/api-docs");
        EXCLUDE_PATHS.add("/error");
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {

        response.setCharacterEncoding("UTF-8");
        RequestTool.setRequestInThreadLocal(request,response);

        try {

            //不是远程调用直接,解析环境参数
            if (!"true".equals(request.getHeader(CustomRequestInterceptor.X_RPC))) {
                URL url = new URL(RequestTool.getHomeURL());
                EnvironmentEnum environment = hostEnvironmentMapping.findEnvironmentByHost(url.getAuthority());
                defaultEnvironmentDecisionMaker.setEnvironment(environment);
            }

            Boolean flag = (Boolean)request.getAttribute(SsoConstants.CAN_ACCESS);
            if(flag!=null){
                return flag;
            }

            String url = request.getRequestURI();
            if (EXCLUDE_PATHS.contains(url)){
                return true;
            }
            if(handler instanceof HandlerMethod){
                HandlerMethod method = (HandlerMethod)handler;
                CanAccess canAccess = AnnotationUtils.findAnnotation(method.getMethod(),CanAccess.class);
                if(!Objects.equal(null,canAccess)){
                    return true;
                }
            }
            //进入拦截队列
            if(!queue.doHandler(handler)){
                return false;
            }
        } catch (SsoException e) {
            if (RequestTool.isAsynchronousRequests()){
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                response.getWriter().write(JsonRender.failResult(e).toJSONString());
            }else{
                response.setHeader("Content-Type", "text/html;charset=UTF-8");
                response.getWriter().write(e.getMessage());
            }
            return false;
        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestTool.removeRequestInThreadLocal();
        defaultEnvironmentDecisionMaker.clear();
    }

    public void setHandleQueue(SsoFilterHandlerQueue queue) {
        this.queue = queue;
    }

}
