package cn.com.duiba.sso.api.service;

import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

public class HostEnvironmentMapping {

    @Resource
    private EnvironmentEnum environmentEnum;

    private Map<String, EnvironmentEnum> mapping = Maps.newHashMap();

    private List<HostEnvironment> relationList = Lists.newArrayList();

    private Map<EnvironmentEnum,String> publicMapping = Maps.newHashMap();

    public void addMapping(String host,EnvironmentEnum environmentEnum){
        addMapping(host,environmentEnum,true);
    }

    public void addMapping(String host,EnvironmentEnum environmentEnum,boolean isPublic){
        mapping.put(host,environmentEnum);
        if(isPublic){
            relationList.add(new HostEnvironment(host,environmentEnum));
            publicMapping.put(environmentEnum,host);
        }
    }

    public String findHostByEnvironment(EnvironmentEnum environment){
        return publicMapping.get(environment);
    }

    public EnvironmentEnum findEnvironmentByHost(String host){
        return mapping.getOrDefault(host,environmentEnum);
    }

    public Boolean containsHost(String host){
        return mapping.containsKey(host);
    }

    public List<HostEnvironment> getHostEnvironmentMappings(){
        return Lists.newArrayList(relationList);
    }

}
