package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping({"/sso/admin","/mobile/sso/admin"})
public class AdminInfoController {

    @Autowired
    private RemoteAdminService remoteAdminService;

    @RequestMapping(value = "/adminInfo",method = RequestMethod.GET)
    public JsonRender adminInfo(){

        JSONObject model = new JSONObject();
        AdminDto admin = RequestTool.getAdmin();

        model.put("adminId",admin.getId());
        model.put("adminName",admin.getName());
        model.put("email",admin.getEmail());

        return JsonRender.successResult(model);
    }

    @RequestMapping(value = "/searchAdminLikeNameOrAccount",method = RequestMethod.GET)
    public JsonRender searchAdminLikeNameOrAccount(@RequestParam String search){

        List<AdminDto> adminDtos = remoteAdminService.findByNameLike(search);

        JsonRender jsonRender = JsonRender.successResult();
        jsonRender.put("adminList",adminDtos);

        return jsonRender;
    }
}
