package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import java.net.URLEncoder;
import java.util.Objects;

public abstract class AbstractLoginFilterHandler implements SsoFilterHandler {

    @Autowired
    private RemoteSSOService remoteSSOService;

    protected abstract String getDefaultRedirectUrl();

    protected abstract String getLoginRedirectUrl();

    @Override
    public int getOrder() {
        return 0;
    }

    /**
     * 验证通行证
     */
    protected AdminDto verifyTicket(String ticket){
        if(StringUtils.isBlank(ticket)){
            return null;
        }
        AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);
        //有可能是根据链接传入的通行证，把它持久化到客户端的cookie中
        if(Objects.nonNull(admin) && StringUtils.isBlank(RequestTool.getCookie(CookieUtil.LOGIN_COOKIE_NAME))){
            CookieUtil.setLoginCookie(ticket,admin.getLoginTimeout());
        }
        return admin;
    }

    /**
     * 把当前请求包装成重定向参数
     */
    protected String getCurrentRedirect(){
        HttpServletRequest request = RequestTool.getRequest();
        String redirect;
        if(StringUtils.equals("/",request.getRequestURI())){
            redirect = RequestTool.getHomeURL()+getDefaultRedirectUrl();
        }else{
            redirect = RequestTool.getUrl();
        }
        try{
            return URLEncoder.encode(redirect,"utf-8");
        }catch (Exception e){
            throw new SsoRunTimeException(e);
        }
    }

    protected void returnNotLogin(){
        try{
            if(RequestTool.isAsynchronousRequests()){
                RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code","SSO:01001");
                model.put("success",false);
                model.put("notLogin",true);
                model.put("message","登录失效，请刷新页面");
                RequestTool.getResponse().getWriter().write(model.toJSONString());
            }else{
                //附上当前请求地址,重定向到SSO登录页
                RequestTool.getResponse().sendRedirect(getLoginRedirectUrl());
            }
        }catch (Exception e){
            throw new SsoRunTimeException(e);
        }
    }

}
