package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.annotation.MobileHandler;
import cn.com.duiba.sso.api.web.interceptor.annotation.PcHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.AuthFilterHandler;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by liuyao on 2017/5/12.
 * 远程权限拦截系统
 */
@MobileHandler
@PcHandler
public class AuthorityFilterHandler extends AuthFilterHandler {

    @Override
    public int getOrder() {
        return 10;
    }
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public Boolean before(Object handler){
        if (hasAuthCanAccess(handler)){
            return true;
        }

        HttpServletRequest request = RequestTool.getRequest();

        String url = request.getRequestURI();

        if(adminPowerCacheService.hasPower(RequestTool.getAdminId(),url)){
            return true;
        }else{
            dontHasPower("无权访问");
            return false;
        }
    }
}
