package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.service.export.ExportFileInfo;
import cn.com.duiba.sso.api.service.export.SsoExportFileService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping("${duiba.sso.root-path:'/sso'}/export")
public class SsoExportFileController {

    @Resource
    private SsoExportFileService ssoExportFileService;

    @CanAccess
    @RequestMapping("/taskInfo")
    public JsonRender taskInfo(@RequestParam Long taskId){
        ExportFileInfo fileInfo = ssoExportFileService.getExportFileInfo(taskId);
        JsonRender render = JsonRender.successResult();
        render.put("info",fileInfo);
        return render;
    }

}
