package cn.com.duiba.sso.api.service;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import lombok.Data;

import java.util.Objects;

@Data
public class HostEnvironment {

    private final String host;
    private final Environment environment;
    private final String cluster;

    HostEnvironment(String host, Environment environment, String cluster){
        this.cluster = cluster;
        this.host = host;
        this.environment = environment;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof HostEnvironment)) return false;
        HostEnvironment that = (HostEnvironment) o;
        return Objects.equals(host, that.host) &&
                environment == that.environment &&
                Objects.equals(cluster, that.cluster);
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, environment, cluster);
    }
}
