/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoUrlService {
    private static final Logger log = LoggerFactory.getLogger(SsoUrlService.class);
    @Resource
    private RemoteSSOService remoteSSOService;

    public String buildOauth2Url(String url) {
        try {
            String redirect = URLEncoder.encode(url, "utf-8");
            String state = UUIDUtils.createSecureUUID();
            HashMap params = Maps.newHashMap();
            params.put("redirect", redirect);
            params.put("state", state);
            return UrlUtils.appendParams((String)(this.remoteSSOService.findSsoHomeUrl() + "/sso/oauth2/authorize"), (Map)params);
        }
        catch (Exception e) {
            log.error("\u6784\u5efaOauth2\u8bf7\u6c42\u5730\u5740\u5931\u8d25", (Throwable)e);
            throw new SsoRunTimeException((Throwable)e);
        }
    }
}

