/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.params.AccessLogParams;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class AccessLogFilterHandler
implements SsoFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(AccessLogFilterHandler.class);
    private static final int LOG_LIMIT = 100;
    @Resource
    private RemoteManagerLogService remoteManagerLogService;
    @Resource(name="$ssoExecutorService")
    private ExecutorService executorService;
    private AtomicReference<Set<AccessLogParams>> reference = new AtomicReference<Set>(Sets.newConcurrentHashSet());

    @Override
    public Boolean before(Object handler) {
        try {
            AccessLogParams accessLog = new AccessLogParams();
            accessLog.setAppId(SystemInfo.getThisSystemId());
            accessLog.setAdminId(RequestTool.getAdminId());
            HttpServletRequest request = RequestTool.getRequest();
            accessLog.setRequestUri(request.getRequestURI());
            accessLog.setRequestParams(JSONObject.toJSONString((Object)request.getParameterMap()));
            accessLog.setDeviceNo(RequestTool.findDeviceNo());
            accessLog.setIp(RequestTool.getIp());
            accessLog.setUuid(RequestTool.getRequestUUID());
            accessLog.setUserAgent(Optional.ofNullable(request.getHeader("User-Agent")).orElse("\u672a\u77e5"));
            this.reference.getAndUpdate(accessLogParams -> {
                accessLogParams.add(accessLog);
                return accessLogParams;
            });
            if (this.reference.get().size() >= 100) {
                this.flush();
            }
        }
        catch (Exception e) {
            log.error("\u91c7\u96c6\u8bbf\u95ee\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        return true;
    }

    @PreDestroy
    @Scheduled(cron="3/3 * * * * ?")
    public void scheduleFlush() {
        this.flush();
    }

    private synchronized void flush() {
        Set<AccessLogParams> logs = this.reference.getAndSet(Sets.newConcurrentHashSet());
        if (logs.isEmpty()) {
            return;
        }
        AccessLogSenderRunnable runnable = new AccessLogSenderRunnable();
        runnable.setLogs(logs);
        this.executorService.submit(runnable);
    }

    public int getOrder() {
        return 5;
    }

    private class AccessLogSenderRunnable
    implements Runnable {
        private Set<AccessLogParams> logs;

        private AccessLogSenderRunnable() {
        }

        @Override
        public void run() {
            try {
                AccessLogFilterHandler.this.remoteManagerLogService.accessLog((List)Lists.newArrayList(this.logs));
            }
            catch (Exception e) {
                log.error("sso access log send error", (Throwable)e);
            }
        }

        void setLogs(Set<AccessLogParams> logs) {
            this.logs = logs;
        }
    }
}

