/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.OutLoginEvent;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class LoginFilterHandler
implements SsoFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(LoginFilterHandler.class);
    private LoadingCache<String, AdminDto> adminDtoCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AdminDto>(){

        public AdminDto load(@Nonnull String ticket) {
            AdminDto adminDao = LoginFilterHandler.this.remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if (adminDao == null) {
                adminDao = new AdminDto();
            }
            return adminDao;
        }
    });
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private RemoteSSOService remoteSSOService;

    @Override
    public Boolean before(Object handler) {
        String ticket = RequestTool.findTicket();
        if (StringUtils.isBlank((CharSequence)ticket)) {
            this.returnNotLogin();
            return false;
        }
        AdminDto admin = this.verifyTicket(ticket);
        if (admin == null) {
            this.returnNotLogin();
            return false;
        }
        RequestTool.setAdmin(admin);
        return true;
    }

    @EventListener(value={OutLoginEvent.class})
    public void outLoginEventListener(OutLoginEvent event) {
        this.adminDtoCache.invalidate((Object)event.getTicket());
    }

    private String getLoginRedirectUrl() {
        HashMap params = Maps.newHashMap();
        String redirect = this.getCurrentRedirect();
        params.put("redirect", redirect);
        params.put("systemId", SystemInfo.getThisSystemId().toString());
        String ssoHomeUrl = this.remoteSSOService.findSsoHomeUrl();
        String loginUrl = ssoHomeUrl + "/login";
        return UrlUtils2.appendParams((String)loginUrl, (Map)params);
    }

    private String getDefaultRedirectUrl() {
        if (RequestTool.isMobile().booleanValue()) {
            return this.ssoProperties.getMobileDefaultRedirectUrl();
        }
        return this.ssoProperties.getDefaultRedirectUrl();
    }

    public int getOrder() {
        return 0;
    }

    protected AdminDto verifyTicket(String ticket) {
        if (StringUtils.isBlank((CharSequence)ticket)) {
            return null;
        }
        AdminDto admin = (AdminDto)this.adminDtoCache.get((Object)ticket);
        if (Objects.requireNonNull(admin).getId() == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)RequestTool.getCookie("sso_ticket"))) {
            CookieUtil.setLoginCookie(ticket);
        }
        return admin;
    }

    protected String getCurrentRedirect() {
        HttpServletRequest request = RequestTool.getRequest();
        String redirect = StringUtils.equals((CharSequence)"/", (CharSequence)request.getRequestURI()) ? RequestTool.getHomeURL() + this.getDefaultRedirectUrl() : RequestTool.getUrl();
        try {
            return URLEncoder.encode(redirect, "utf-8");
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    protected void returnNotLogin() {
        try {
            if (RequestTool.isAsynchronousRequests().booleanValue()) {
                RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code", (Object)"SSO:01001");
                model.put("success", (Object)false);
                model.put("notLogin", (Object)true);
                model.put("message", (Object)"\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
                RequestTool.getResponse().getWriter().write(model.toJSONString());
            } else {
                RequestTool.getResponse().sendRedirect(this.getLoginRedirectUrl());
            }
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }
}

