/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.SsoBasicConfiguration;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.service.HostEnvironmentMapping;
import cn.com.duiba.sso.api.service.SsoUrlService;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.export.SsoExportFileConfiguration;
import cn.com.duiba.sso.api.web.interceptor.MobileInterceptor;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.AccessLogFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.AuthorityFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.LoginFilterHandler;
import cn.com.duiba.sso.api.web.logger.DefaultSsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.web.power.AuthorizeInterceptor;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ComponentScan(value={"cn.com.duiba.sso.api.web"})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={SsoBasicConfiguration.class})
@EnableConfigurationProperties(value={SsoProperties.class})
@Import(value={SsoBasicConfiguration.class, SsoExportFileConfiguration.class})
@Order(value=-1)
public class SsoAutoConfiguration
implements WebMvcConfigurer {
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private ApplicationContext applicationContext;

    @Bean
    public RequestTool initRequestTool() {
        return new RequestTool();
    }

    @Bean
    public HostEnvironmentMapping hostEnvironmentMapping() {
        return new HostEnvironmentMapping();
    }

    @Bean
    public SsoUrlService ssoUrlService() {
        return new SsoUrlService();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = this.ssoProperties.getPathPatterns();
        String[] paths = StringUtils.split((String)pathPatterns, (String)",");
        String excludePathPatterns = this.ssoProperties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty((String)excludePathPatterns) ? new String[]{} : StringUtils.split((String)excludePathPatterns, (String)",");
        String mobilePathPatterns = this.ssoProperties.getMobilePathPatterns();
        String[] mobilePaths = StringUtils.split((String)mobilePathPatterns, (String)",");
        MobileInterceptor mobileInterceptor = new MobileInterceptor();
        registry.addInterceptor((HandlerInterceptor)mobileInterceptor).addPathPatterns(mobilePaths);
        SsoInterceptor ssoInterceptor = (SsoInterceptor)((Object)this.applicationContext.getBean(SsoInterceptor.class));
        registry.addInterceptor((HandlerInterceptor)ssoInterceptor).addPathPatterns(paths).addPathPatterns(new String[]{"/auth/**"}).addPathPatterns(new String[]{"/sso/**"}).excludePathPatterns(excludePath);
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoInterceptor ssoInterceptor(List<SsoFilterHandler> ssoFilterHandlers) {
        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        SsoInterceptor ssoInterceptor = new SsoInterceptor();
        for (SsoFilterHandler handler : ssoFilterHandlers) {
            queue.addHandler(handler);
        }
        ssoInterceptor.setHandleQueue(queue);
        return ssoInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter() {
        return new DefaultSsoLoggerMateInfoAdapter();
    }

    @Bean
    @ConditionalOnMissingBean
    public LoginFilterHandler loginFilterHandler() {
        return new LoginFilterHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorityFilterHandler authorityFilterHandler() {
        return new AuthorityFilterHandler();
    }

    @Bean
    public AccessLogFilterHandler accessLogFilterHandler() {
        return new AccessLogFilterHandler();
    }

    @Bean
    public AuthorizeInterceptor authorizeInterceptor() {
        return new AuthorizeInterceptor();
    }
}

