/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.export;

import cn.com.duiba.sso.api.tool.FileUtils;
import cn.com.duiba.sso.api.web.export.ExportFileInfo;
import cn.com.duiba.sso.api.web.export.SsoExportFileService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import java.io.File;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
public abstract class BaseExportRunnable
implements Runnable {
    private final String taskId = UUIDUtils.createUUID();
    @Autowired
    private SsoExportFileService ssoExportFileService;
    private File file;

    void init() {
        ExportFileInfo info = new ExportFileInfo();
        info.setTaskId(this.taskId);
        info.setSuccessCount(0);
        info.setCount(this.count());
        info.setSuccess(false);
        info.setUrl("");
        String fileName = this.fileName();
        String fileType = this.fileType();
        File tempDir = FileUtils.getTempDir();
        this.file = new File(tempDir, fileName + "-" + System.currentTimeMillis() + "." + fileType);
        info.setFileName(this.file.getName());
        this.ssoExportFileService.publishExportFileInfo(info);
    }

    public String getTaskId() {
        return this.taskId;
    }

    protected File getExportFile() {
        return this.file;
    }

    public void setIncrementCount(Integer count) {
        Objects.requireNonNull(count);
        if (count == 0) {
            return;
        }
        ExportFileInfo info = this.ssoExportFileService.getExportFileInfo(this.taskId);
        info.setSuccessCount(info.getSuccessCount() + count);
        this.ssoExportFileService.publishExportFileInfo(info);
    }

    protected abstract Integer count();

    protected abstract String fileName();

    protected abstract String fileType();

    protected void complete(String url) {
        ExportFileInfo info = this.ssoExportFileService.getExportFileInfo(this.taskId);
        info.setUrl(url);
        info.setSuccess(true);
        this.ssoExportFileService.publishExportFileInfo(info);
    }

    protected void error(String message) {
        ExportFileInfo info = this.ssoExportFileService.getExportFileInfo(this.taskId);
        info.setMessage(message);
        info.setSuccess(true);
        this.ssoExportFileService.publishExportFileInfo(info);
    }
}

