/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.tool.RequestTool;
import javax.servlet.http.Cookie;

public class CookieUtil {
    public static final String LOGIN_COOKIE_NAME = "sso_ticket";
    public static final String DEVICE_NO = "device_no";

    public static Cookie createCookie(String name, String value, Integer timeout) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(timeout.intValue());
        return cookie;
    }

    public static void setCookie(String name, String value, Integer timeout) {
        Cookie cookie = CookieUtil.createCookie(name, value, timeout);
        RequestTool.addCookie(cookie);
    }

    public static void setLoginCookie(String ticket) {
        Cookie cookie = CookieUtil.createCookie(LOGIN_COOKIE_NAME, ticket, 473040000);
        RequestTool.addCookie(cookie);
    }

    public static void deleteCookie(String name) {
        Cookie cookie = CookieUtil.createCookie(name, null, 0);
        RequestTool.addCookie(cookie);
    }

    public static String getCookie(String name) {
        return RequestTool.getCookie(name);
    }
}

