/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.power;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.power.SsoResourceFieldFilter;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.PreAuthorize;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class AuthorizeInterceptor {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private SsoResourceFieldFilter ssoResourceFieldFilter;
    private ExpressionParser parser = new SpelExpressionParser();
    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    @Around(value="@annotation(PreAuthorize)")
    public Object preProcessQueryPattern(ProceedingJoinPoint point) throws Throwable {
        Object[] arguments = point.getArgs();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        PreAuthorize preAuthorize = (PreAuthorize)AnnotationUtils.findAnnotation((Method)method, PreAuthorize.class);
        String[] paramNames = this.discoverer.getParameterNames(method);
        Expression expression = this.parser.parseExpression(preAuthorize.value());
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < arguments.length; ++i) {
            context.setVariable(paramNames[i], arguments[i]);
        }
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        expression.getValue((EvaluationContext)context, Void.class);
        return point.proceed();
    }

    @AfterReturning(value="@annotation(cn.com.duiba.sso.api.web.power.SsoResourceFieldAuthorize)", returning="collection")
    public void ssoContentPreAuthorize(Collection collection) {
        Long adminId = RequestTool.getAdminId();
        if (Objects.isNull(adminId)) {
            throw new SsoRunTimeException("\u65e0\u6cd5\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237");
        }
        this.ssoResourceFieldFilter.doFilter(adminId, collection);
    }
}

