package cn.com.duiba.sso.api.service;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.net.URLEncoder;
import java.util.Map;


@Slf4j
public class SsoUrlService {

    @Resource
    private RemoteSSOService remoteSSOService;

    /**
     * 构建Oauth2请求地址
     */
    public String buildOauth2Url(String url){
        try{
            String redirect = URLEncoder.encode(url,"utf-8");
            String state = UUIDUtils.createSecureUUID();

            Map<String,String> params = Maps.newHashMap();
            params.put("redirect",redirect);
            params.put("state",state);

            return UrlUtils.appendParams(remoteSSOService.findSsoHomeUrl()+"/sso/oauth2/authorize",params);

        }catch (Exception e){
            log.error("构建Oauth2请求地址失败",e);
            throw new SsoRunTimeException(e);
        }
    }
}
