package cn.com.duiba.sso.api.service.loginlink;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.params.LoginLinkParams;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.apache.commons.lang.StringUtils;

import javax.annotation.Resource;
import java.util.Date;

public class SsoLoginLinkService {

    private static TransmittableThreadLocal<String> traces = new TransmittableThreadLocal<>();

    public static final String SSO_LOGIN_LINK_TRACE_ID = "trace_id";

    @Resource
    private RemoteManagerLogService remoteManagerLogService;

    public void trace(){
        String traceId = CookieUtil.getCookie(SSO_LOGIN_LINK_TRACE_ID);
        if(StringUtils.isBlank(traceId)){
            traceId =  RequestTool.getRequestParamMap().get(SSO_LOGIN_LINK_TRACE_ID);
        }
        if(StringUtils.isNotBlank(traceId)){
            traces.set(traceId);
        }
    }

    public void trace(String traceId){
        traces.set(traceId);
    }

    public boolean isTrace(){
        return StringUtils.isNotBlank(traces.get());
    }

    public String getTraceId(){
        return traces.get();
    }

    public String createTrace(){
        String id = UUIDUtils.createUUID();
        traces.set(id);
        return id;
    }

    public void span(String description,Boolean isFrist){
        if(!isTrace()){
            return;
        }
        String spanId =isFrist?traces.get():UUIDUtils.createUUID();
        LoginLinkParams params = new LoginLinkParams();
        params.setTraceId(traces.get());
        params.setSpanId(spanId);
        params.setDeviceNo(RequestTool.findDeviceNo());

        AdminDto adminDto = RequestTool.getAdmin();
        if(adminDto!=null){
            params.setAdminId(adminDto.getId());
        }
        params.setActionTime(new Date());
        params.setIp(RequestTool.getIp());
        params.setTicket(RequestTool.findTicket());
        params.setAppAlias(SystemInfo.getSystemAlias());
        params.setDescription(description);

        remoteManagerLogService.loginLinkLog(params);

    }

    public void clear(){
        traces.remove();
    }


}
