package cn.com.duiba.sso.api.web.export;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("${duiba.sso.root-path:'/sso'}/export")
public class SsoExportFileController {

    @Autowired(required = false)
    private SsoExportFileService ssoExportFileService;


    @CanAccess
    @RequestMapping("/taskInfo")
    public JsonRender taskInfo(@RequestParam Long taskId){
        if(ssoExportFileService==null){
            throw new SsoRunTimeException("SSO下载模块未启用");
        }
        ExportFileInfo fileInfo = ssoExportFileService.getExportFileInfo(taskId);
        JsonRender render = JsonRender.successResult();
        render.put("info",fileInfo);
        return render;
    }

}
