package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by liuyao on 2017/5/12.
 * 权限拦截系统
 */
public class AuthorityFilterHandler implements SsoFilterHandler {

    @Resource
    private Environment currentEnvironment;
    @Resource
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public Boolean before(Object handler){
        if (hasAuthCanAccess(handler)){
            return true;
        }
        ApplicationDto system = SystemInfo.getThisSystemInfo();
        AdminDto admin = RequestTool.getAdmin();

        if(!RequestTool.isMobile() && !admin.getSystemIdSet().contains(system.getId())){
            dontHasPower("尊敬的"+admin.getName()+"，您暂时没有"+system.getAppName()+"的访问权限");
            return false;
        }

        HttpServletRequest request = RequestTool.getRequest();
        String url = request.getRequestURI();

        if(adminPowerCacheService.hasPower(RequestTool.getAdminId(),url)){
            return true;
        }else{
            dontHasPower("无权访问");
            return false;
        }
    }

    protected Boolean hasAuthCanAccess(Object handler){
        if(handler instanceof HandlerMethod){
            HandlerMethod method = (HandlerMethod)handler;
            AuthCanAccess canAccess = AnnotationUtils.findAnnotation(method.getMethod(),AuthCanAccess.class);
            return !Objects.equal(null, canAccess);
        }
        if(!Environment.DEV.equals(currentEnvironment)){
            return false;
        }
        AdminDto admin = RequestTool.getAdmin();
        return StringUtils.equals("swagger@duiba.com.cn",admin.getEmail());
    }

    protected void dontHasPower(String message){

        HttpServletResponse response = RequestTool.getResponse();
        String context;

        if(RequestTool.isAsynchronousRequests()){
            JSONObject json = new JSONObject();
            json.put("code","SSO:01002");
            json.put("success",false);
            json.put("desc","无权访问");
            json.put("message",message);
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            context = json.toJSONString();
        }else{//重定向到无权页面
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            context = message;
        }
        try {
            response.getWriter().write(context);
        } catch (IOException e) {
            throw new SsoRunTimeException(e);
        }
    }

    @Override
    public int getOrder() {
        return 10;
    }


}
