/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.loginlink;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.params.LoginLinkParams;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class SsoLoginLinkService {
    private static TransmittableThreadLocal<String> traces = new TransmittableThreadLocal();
    public static final String SSO_LOGIN_LINK_TRACE_ID = "trace_id";
    @Resource
    private RemoteManagerLogService remoteManagerLogService;

    public void trace() {
        String traceId = CookieUtil.getCookie(SSO_LOGIN_LINK_TRACE_ID);
        if (StringUtils.isBlank((String)traceId)) {
            traceId = RequestTool.getRequestParamMap().get(SSO_LOGIN_LINK_TRACE_ID);
        }
        if (StringUtils.isNotBlank((String)traceId)) {
            traces.set((Object)traceId);
        }
    }

    public void trace(String traceId) {
        traces.set((Object)traceId);
    }

    public boolean isTrace() {
        return StringUtils.isNotBlank((String)((String)traces.get()));
    }

    public String getTraceId() {
        return (String)traces.get();
    }

    public String createTrace() {
        String id = UUIDUtils.createUUID();
        traces.set((Object)id);
        return id;
    }

    public void span(String description, Boolean isFrist) {
        if (!this.isTrace()) {
            return;
        }
        String spanId = isFrist != false ? (String)traces.get() : UUIDUtils.createUUID();
        LoginLinkParams params = new LoginLinkParams();
        params.setTraceId((String)traces.get());
        params.setSpanId(spanId);
        params.setDeviceNo(RequestTool.findDeviceNo());
        AdminDto adminDto = RequestTool.getAdmin();
        if (adminDto != null) {
            params.setAdminId(adminDto.getId());
        }
        params.setActionTime(new Date());
        params.setIp(RequestTool.getIp());
        params.setTicket(RequestTool.findTicket());
        params.setAppAlias(SystemInfo.getSystemAlias());
        params.setDescription(description);
        this.remoteManagerLogService.loginLinkLog(params);
    }

    public void clear() {
        traces.remove();
    }
}

