/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.service.HostEnvironmentMapping;
import cn.com.duiba.sso.api.service.loginlink.SsoLoginLinkService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class SsoInterceptor
extends HandlerInterceptorAdapter {
    private SsoFilterHandlerQueue queue;
    private static final Set<String> EXCLUDE_PATHS = Sets.newHashSet();
    @Resource
    private HostEnvironmentMapping hostEnvironmentMapping;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private SsoLoginLinkService ssoLoginLinkService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.setCharacterEncoding("UTF-8");
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        RequestTool.setRequestInThreadLocal(request, response);
        try {
            HandlerMethod method;
            CanAccess canAccess;
            this.ssoLoginLinkService.trace();
            if (!"true".equals(request.getHeader("X-Rpc"))) {
                URL url = new URL(RequestTool.getHomeURL());
                Environment environment = this.hostEnvironmentMapping.findEnvironmentByHost(url.getAuthority());
                this.requestEnvironmentDecisionMaker.$$SetEnvironment(environment);
            }
            Boolean flag1 = Optional.ofNullable((Boolean)request.getAttribute("CanAccess")).orElse(false);
            Boolean flag2 = Optional.ofNullable((Boolean)request.getAttribute("APP_BOOT_MAPPING_MODE")).orElse(false);
            if (flag1.booleanValue() || flag2.booleanValue()) {
                return true;
            }
            String url = request.getRequestURI();
            if (EXCLUDE_PATHS.contains(url)) {
                return true;
            }
            if (handler instanceof HandlerMethod && !Objects.equal(null, (Object)(canAccess = (CanAccess)AnnotationUtils.findAnnotation((Method)(method = (HandlerMethod)handler).getMethod(), CanAccess.class)))) {
                return true;
            }
            if (!this.queue.doHandler(handler).booleanValue()) {
                return false;
            }
        }
        catch (SsoException e) {
            if (RequestTool.isAsynchronousRequests().booleanValue()) {
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                response.getWriter().write(JsonRender.failResult(e).toJSONString());
            } else {
                response.setHeader("Content-Type", "text/html;charset=UTF-8");
                response.getWriter().write(e.getMessage());
            }
            return false;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        RequestTool.removeRequestInThreadLocal();
        this.requestEnvironmentDecisionMaker.$$Clear();
    }

    public void setHandleQueue(SsoFilterHandlerQueue queue) {
        this.queue = queue;
    }

    public void addExcludePath(String ... path) {
        EXCLUDE_PATHS.addAll(Sets.newHashSet((Object[])path));
    }

    static {
        EXCLUDE_PATHS.add("/favicon.ico");
        EXCLUDE_PATHS.add("/monitor/check");
        EXCLUDE_PATHS.add("/swagger-ui.html");
        EXCLUDE_PATHS.add("/swagger-resources");
        EXCLUDE_PATHS.add("/swagger-resources/configuration/ui");
        EXCLUDE_PATHS.add("/v2/api-docs");
        EXCLUDE_PATHS.add("/error");
    }
}

