package cn.com.duiba.sso.api.web.logger;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.LoginStateDto;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.UUIDUtils;
import org.springframework.stereotype.Component;

/**
 * @author liuyao
 */
@Component
public class DefaultSsoLoggerMateInfoAdapter implements SsoLoggerMateInfoAdapter {

    @Override
    public SsoLoggerMateInfo getLoggerMateInfo() {
        SsoLoggerMateInfo mateInfo = new SsoLoggerMateInfo();
        RequestParams requestParams = RequestTool.getRequestParams();
        LoginStateDto loginState = requestParams.getLoginState();
        if(loginState!=null){
            mateInfo.setAdminId(RequestTool.getAdminId());
        }
        mateInfo.setIp(requestParams.getIp());
        mateInfo.setDevAppId(0L);
        return mateInfo;
    }

}
