/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.sso.api.common.tree.Tree;
import cn.com.duiba.sso.api.common.tree.TreeFactory;
import cn.com.duiba.sso.api.common.tree.TreeView;
import cn.com.duiba.sso.api.domain.bizenum.CacheKeyEnum;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.domain.event.PowerUpdateEvent;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.service.eventbus.BizEventListener;
import cn.com.duiba.sso.api.tool.SystemInfo;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
@BizEventListener
public class PowerTreeService {
    private static final Long POWER_FLASH_TIME = 30L;
    private StampedLock lock = new StampedLock();
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private volatile Tree<PowerDto> powerTree = TreeFactory.createTree(Collections.emptyList());
    private static Map<String, Set<Long>> POWER_URL_MAP = Maps.newConcurrentMap();
    private AtomicLong powerTreeVersion = new AtomicLong(0L);

    @PostConstruct
    public void init() {
        this.executorService.scheduleWithFixedDelay(new PowerTreeFlushTask(), POWER_FLASH_TIME, POWER_FLASH_TIME, TimeUnit.SECONDS);
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    public void SystemInfoInitComplateEventListener() {
        this.loadPowerTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getPowerIdsByUrl(String url) {
        if (this.powerTreeVersion.get() == 0L) {
            throw new SsoRunTimeException("\u6743\u9650\u7cfb\u7edf\u670d\u52a1\u672a\u521d\u59cb\u5316\u6210\u529f,\u8bf7\u7a0d\u540e...");
        }
        long stamp = this.lock.tryOptimisticRead();
        Set<Long> powerIds = POWER_URL_MAP.getOrDefault(url, Collections.emptySet());
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                powerIds = POWER_URL_MAP.getOrDefault(url, Collections.emptySet());
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        return powerIds;
    }

    public PowerDto getPower(Long PowerId) {
        return this.powerTree.getNode(PowerId);
    }

    public <T extends TreeView<T>> List<T> getPowerTree(Function<PowerDto, T> transform) {
        return this.getPowerTree(Collections.emptySet(), transform);
    }

    public <T extends TreeView<T>> List<T> getPowerTree(Set<Long> hasPowerIdSet, Function<PowerDto, T> transform) {
        List<PowerDto> nodeList = this.powerTree.getTreeView();
        ArrayList list = Lists.newArrayList();
        for (PowerDto power : nodeList) {
            if (!hasPowerIdSet.isEmpty() && !hasPowerIdSet.contains(power.getId())) continue;
            TreeView node = (TreeView)transform.apply(power);
            if (node.getId() == null || node.getParentId() == null) {
                throw new SsoRunTimeException("Function\u8f6c\u5316\u65b9\u6cd5\u5fc5\u987b\u5b8c\u6210Id\u548cparentId\u7684\u8f6c\u5316");
            }
            list.add(node);
        }
        Tree tree = TreeFactory.createTree(list);
        return TreeFactory.transformTree(tree);
    }

    public List<PowerDto> getPowerWay(Long powerId) {
        return this.powerTree.getOneWayView(powerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPowerTree() {
        Long systemId = SystemInfo.getThisSystemId();
        List<PowerDto> treeList = this.remotePermissionService.loadPowerList(systemId);
        Tree<PowerDto> tree = TreeFactory.createTree(treeList);
        HashMultimap urlMap = HashMultimap.create();
        for (PowerDto power : treeList) {
            for (String url : power.getUrls()) {
                urlMap.put((Object)url, (Object)power.getId());
            }
        }
        long stamp = this.lock.writeLock();
        try {
            this.powerTree = tree;
            POWER_URL_MAP.clear();
            for (String url : urlMap.keySet()) {
                POWER_URL_MAP.put(url, urlMap.get((Object)url));
            }
            if (this.powerTreeVersion.get() == 0L) {
                this.powerTreeVersion.set(new Date().getTime());
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Subscribe
    public void PowerUpdateEventListener(PowerUpdateEvent event) {
        String key = CacheKeyEnum.SSO_POWER_TREE_VERSION.getCacheKey(event.getSystemId());
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)key);
        operations.set((Object)String.valueOf(new Date().getTime()), 1L, TimeUnit.DAYS);
    }

    private class PowerTreeFlushTask
    implements Runnable {
        private PowerTreeFlushTask() {
        }

        @Override
        public void run() {
            if (PowerTreeService.this.powerTreeVersion.get() == 0L) {
                PowerTreeService.this.loadPowerTree();
                return;
            }
            String key = CacheKeyEnum.SSO_POWER_TREE_VERSION.getCacheKey(SystemInfo.getThisSystemId());
            BoundValueOperations operations = PowerTreeService.this.stringRedisTemplate.boundValueOps((Object)key);
            String versionStr = (String)operations.get();
            if (StringUtils.isBlank((CharSequence)versionStr)) {
                return;
            }
            Long version = Long.valueOf(versionStr);
            if (PowerTreeService.this.powerTreeVersion.get() >= version) {
                return;
            }
            PowerTreeService.this.loadPowerTree();
            PowerTreeService.this.powerTreeVersion.set(version);
        }
    }
}

