package cn.com.duiba.sso.api.common.tree;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

/**
 * Created by liqing on 2017/7/25.
 */
public class TreeFactory{


    public static <T extends TreeNodeShim> Tree<T> createTree(List<T> entreList){

        List<T> cache = Lists.newLinkedList();

        Tree<T> tree = new Tree<>();
        cache.addAll(entreList);
        try{
            int size = cache.size();
            while(size!=0){
                ListIterator<T> items = cache.listIterator();
                while(items.hasNext()){
                    T node = items.next();
                    if(tree.containsId(node.getParentId())){
                        tree.addNode(node);
                        items.remove();
                    }
                }
                if(cache.size()==size){
                    throw new RuntimeException("创建树时，存在无父节点的子节点");
                }
                size = cache.size();
            }
        }catch(Exception e){
            throw new RuntimeException("数据库中父子关系异常");
        }
        return tree;
    }

    /**
     * 把树转化成二维的树形视图
     */
    public static <T extends TreeView<T>> List<T> transformTree(Tree<T> tree){
        if(tree.size()==0){
            return Collections.emptyList();
        }
        List<T> viewList = Lists.newArrayList();
        List<T> list = tree.getTreeView();

        Stack<T> stack = new Stack<>();

        for(T item : list){
            if(stack.isEmpty()){
                stack.push(item);
                continue;
            }
            T top = stack.peek();
            if(top.getLevel()<item.getLevel()){//如果大于栈顶，加在子代上
                if(item.getLevel()-top.getLevel()==1){
                    top.addChild(item);
                }else{
                    List<T> childs = top.getChild();
                    stack.push(childs.get(childs.size()-1));
                    stack.peek().addChild(item);
                }
                continue;
            }
            if(Objects.equal(top.getLevel(),item.getLevel())){//如果是平行的节点，用item替代top,原top进入到树中
                T ytop = stack.pop();
                if(ytop.getLevel()==1){
                    viewList.add(ytop);
                }else{
                    stack.peek().addChild(item);
                }
                stack.push(item);
                continue;
            }
            if(top.getLevel()>item.getLevel()){
                long levelDifference = top.getLevel() - item.getLevel();
                for(int i=0;i<=levelDifference;i++){
                    T sackItem = stack.pop();
                    if(sackItem.getLevel()==1L){
                        viewList.add(sackItem);
                    }
                }
                stack.push(item);
            }
        }
        //最后的结果：栈里剩一个根节点
        viewList.add(stack.pop());
        return viewList;
    }


}
