package cn.com.duiba.sso.api.service.logger.domain;


import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Stack;

public class SsoLoggerStackContext {

    private static final Logger logger = LoggerFactory.getLogger(SsoLoggerStackContext.class);

    private static final int MAX_LOG_NUM = 30;

    private Stack<SsoLoggerTheadContext> loggerStack = new Stack<>();

    public void addContext(SsoLoggerTheadContext context){
        if (loggerStack.size()>=30){
            logger.warn("管理员操作日志提交量已经操过上限:"+MAX_LOG_NUM);
            return;
        }
        loggerStack.push(context);
    }

    public void addLogParams(JSONObject params){
        if(loggerStack.isEmpty()){
            return;
        }
        SsoLoggerTheadContext context = loggerStack.peek();
        context.addParams(params);
    }

    public SsoLoggerTheadContext popContext(){
        if(loggerStack.isEmpty()){
            return null;
        }
        return loggerStack.pop();
    }

    public Boolean isEmpty(){
        return loggerStack.isEmpty();
    }
}
