/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.logger.service;

import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.service.logger.SsoLogger;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerStackContext;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.service.logger.runnable.AccessLoggerRunnable;
import cn.com.duiba.sso.api.service.logger.runnable.SsoLoggerRunnable;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class SsoLoggerService
implements InitializingBean {
    @Resource
    private ExecutorService executorService;
    @Resource
    private RemoteManagerLogService remoteManagerLogService;
    private SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter;
    private ThreadLocal<SsoLoggerStackContext> threadContext = new ThreadLocal();

    public void setSsoLoggerMateInfoAdapter(SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter) {
        this.ssoLoggerMateInfoAdapter = ssoLoggerMateInfoAdapter;
    }

    public void log(JSONObject json) {
        SsoLoggerStackContext context = this.threadContext.get();
        if (context == null) {
            return;
        }
        context.addLogParams(json);
    }

    public SsoLoggerStackContext initStackContext() {
        SsoLoggerStackContext context = this.threadContext.get();
        if (context == null) {
            context = new SsoLoggerStackContext();
            this.threadContext.set(context);
        }
        return context;
    }

    public void setThreadContext(SsoLoggerTheadContext context) {
        SsoLoggerStackContext stackContext = this.initStackContext();
        if (stackContext == null) {
            return;
        }
        stackContext.addContext(context);
    }

    public void flushThreadContext() {
        SsoLoggerStackContext context = this.threadContext.get();
        if (Objects.equal(null, (Object)context)) {
            return;
        }
        SsoLoggerTheadContext theadContext = context.popContext();
        SsoLoggerRunnable runnable = new SsoLoggerRunnable();
        runnable.setAdminId(this.ssoLoggerMateInfoAdapter.getAdminId());
        runnable.setMateInfo(this.ssoLoggerMateInfoAdapter.getLoggerMateInfo());
        runnable.setContext(theadContext);
        runnable.setRemoteManagerLogService(this.remoteManagerLogService);
        this.executorService.submit(runnable);
        if (context.isEmpty().booleanValue()) {
            this.threadContext.remove();
        }
    }

    public void afterPropertiesSet() {
        SsoLogger.setSsoLoggerService(this);
    }

    public void sendAccessLog(AccessLoggerRunnable runnable) {
        runnable.setRemoteManagerLogService(this.remoteManagerLogService);
        this.executorService.submit(runnable);
    }
}

