/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.event.SsoSystemInitSuccessEvent;
import cn.com.duiba.sso.api.domain.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.tool.SsoVersion;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class SystemInfo {
    private Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private static AtomicReference<SystemDto> system = new AtomicReference();
    private static RemoteSystemService remoteSystemService;
    private static volatile String systemAlias;
    private static Long NO_REGIST_SYS_ID;
    @Autowired
    private SsoEventBus eventBus;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private SpringApplicationProperties springApplicationProperties;

    @Autowired
    public void setRemoteSystemService(RemoteSystemService remoteSystemService) {
        SystemInfo.remoteSystemService = remoteSystemService;
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    public void MainContextRefreshedEventListener() {
        systemAlias = Optional.ofNullable(this.springApplicationProperties.getPriorName()).orElse(this.springApplicationProperties.getName());
        if (StringUtils.isBlank((CharSequence)systemAlias)) {
            throw new SsoRunTimeException("Sso\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e spring.application.name \u7cfb\u7edf\u522b\u540d");
        }
        this.executorService.submit(new Runnable(){
            private Integer count = 10;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                do {
                    Object object;
                    try {
                        SystemDto systemDto = remoteSystemService.getSystemByAlias(systemAlias);
                        if (systemDto == null) {
                            systemDto = new SystemDto();
                            systemDto.setId(NO_REGIST_SYS_ID);
                        }
                        system.set(systemDto);
                        String version = SsoVersion.getVersion();
                        if (StringUtils.isNotBlank((CharSequence)version)) {
                            remoteSystemService.submitSsoVersion(systemDto.getId(), version);
                        }
                        object = this;
                        Integer n = object.count;
                    }
                    catch (Exception e) {
                        1 var1_1;
                        try {
                            SystemInfo.this.logger.error("\u52a0\u8f7d\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                            var1_1 = this;
                            Integer n = var1_1.count;
                        }
                        catch (Throwable throwable) {
                            1 var7_8 = this;
                            Integer n = var7_8.count;
                            Integer n2 = var7_8.count = Integer.valueOf(var7_8.count - 1);
                            throw throwable;
                        }
                        var1_1.count = var1_1.count - 1;
                        object = var1_1.count;
                    }
                    Integer n = object.count = Integer.valueOf(object.count - 1);
                    break;
                } while (this.count > 0 && system.get() == null);
                if (!Objects.equals(NO_REGIST_SYS_ID, ((SystemDto)system.get()).getId())) {
                    SystemInfo.this.eventBus.post(new SsoSystemInitSuccessEvent());
                }
            }
        });
    }

    public static SystemDto getThisSystemInfo() {
        while (system.get() == null) {
        }
        SystemDto systemDto = system.get();
        if (Objects.equals(NO_REGIST_SYS_ID, systemDto.getId())) {
            throw new SsoRunTimeException("\u672a\u627e\u5230" + systemAlias + "\u5bf9\u5e94\u7684\u7cfb\u7edf\u914d\u7f6e");
        }
        return systemDto;
    }

    public static String getThisSystemAlias() {
        return systemAlias;
    }

    public static Long getThisSystemId() {
        return SystemInfo.getThisSystemInfo().getId();
    }

    static {
        NO_REGIST_SYS_ID = -1L;
    }
}

