package cn.com.duiba.sso.api.tool.threadpool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * Created by liuyao on 2017/8/12.
 * 当线程缓存队列满了的时候,抛出异常,同时生成报警日志
 */
public class AbortPolicyWithReport extends ThreadPoolExecutor.AbortPolicy  {

    protected static final Logger logger = LoggerFactory.getLogger(AbortPolicyWithReport.class);

    public AbortPolicyWithReport() {

    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        String msg = String.format("%s, Thread pool is EXHAUSTED!" +
                        " Pool Size: %d (active: %d, core: %d, max: %d, largest: %d), Task: %d (completed: %d)," +
                        " Executor status:(isShutdown:%s, isTerminated:%s, isTerminating:%s)" ,
                Thread.currentThread().getName(), e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(),
                e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating());
        logger.error(msg);
        throw new RejectedExecutionException(msg);
    }

}
