package cn.com.duiba.sso.api.tool.threadpool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by liuyao on 2017/8/12.
 */
public class NameThreadFactory implements ThreadFactory {

    private static final AtomicInteger THREAD_NUM = new AtomicInteger(1);

    private static final String  THREAD_NAME_SEPARATOR = "-";

    /*是否创建守护线程*/
    private Boolean daemo = false;

    private String prefix;

    private ThreadGroup threadGroup;

    public NameThreadFactory(String prefix){
        this(prefix,false);
    }

    public NameThreadFactory(String prefix,Boolean daemo){
        this.daemo = daemo;
        this.prefix = prefix;
        SecurityManager securityManager = System.getSecurityManager();
        this.threadGroup = (securityManager==null)?Thread.currentThread().getThreadGroup():securityManager.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = buildThreadName();
        Thread thread = new Thread(threadGroup,runnable,name,0);
        thread.setDaemon(daemo);
        return thread;
    }

    private String buildThreadName(){
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(THREAD_NAME_SEPARATOR).append(THREAD_NUM.getAndIncrement());
        return sb.toString();
    }
}
