/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.mappingmode.SsoInterfaceManager;
import cn.com.duiba.sso.api.mappingmode.SsoMappingModePlugin;
import cn.com.duiba.sso.api.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.tool.SystemInfo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@EnableConfigurationProperties(value={SpringApplicationProperties.class, SsoBasicProperties.class})
@ComponentScan(value={"cn.com.duiba.sso.api"})
@ImportResource(value={"classpath:sso-common-task.xml"})
public class SsoBasicConfiguration {
    @Autowired
    private SsoBasicProperties ssoBasicProperties;

    @Bean
    public SystemInfo initSysytem() {
        return new SystemInfo();
    }

    @Bean
    @ConditionalOnProperty(name={"duiba.sso.mapping-mode"}, havingValue="true", matchIfMissing=false)
    public SsoMappingModePlugin openSsoMappingMode() {
        if (StringUtils.isBlank((String)this.ssoBasicProperties.getAppSecret())) {
            throw new SsoRunTimeException("\u542f\u52a8SSO\u6620\u5c04\u6a21\u5f0f\u5fc5\u987b\u914d\u7f6eduiba.sso.app-secret");
        }
        return new SsoMappingModePlugin();
    }

    @Bean
    public SsoInterfaceManager ssoMappingModeHttpClient() {
        return new SsoInterfaceManager();
    }
}

