/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.mappingmode;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.mappingmode.MappingModeRequest;
import cn.com.duiba.sso.api.mappingmode.MappingModeRequestMateInfo;
import cn.com.duiba.sso.api.mappingmode.MappingModeResponce;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.tool.SignTool;
import cn.com.duibaboot.ext.autoconfigure.accesslog.MD5;
import com.alibaba.fastjson.JSONArray;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SsoInterfaceManager {
    @Autowired
    private HttpClient httpClient;
    @Autowired
    private SsoBasicProperties ssoBasicProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MappingModeResponce mappingRequest(MappingModeRequest request) {
        try {
            MappingModeResponce responce;
            HttpPost post = new HttpPost(this.ssoBasicProperties.getMappingSsoUrl() + "/sso/mappingModeInterface");
            byte[] bytes = this.hessianCoder(request);
            ByteArrayEntity entity = new ByteArrayEntity(bytes);
            post.setEntity((HttpEntity)entity);
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)post);
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw new SsoRunTimeException("\u8bf7\u6c42\u670d\u52a1\u5931\u8d25:" + status);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()));
            try (Hessian2Input hIn = new Hessian2Input((InputStream)in);){
                responce = (MappingModeResponce)hIn.readObject();
            }
            return responce;
        }
        catch (Exception e) {
            return new MappingModeResponce(e);
        }
    }

    public String createSign(String appSecret, MappingModeRequest request) {
        MappingModeRequestMateInfo mateInfo = request.getMateInfo();
        HashMap params = Maps.newHashMap();
        params.put("systemName", mateInfo.getSystemName());
        params.put("interfaceName", mateInfo.getInterfaceName());
        params.put("method", mateInfo.getMethod());
        params.put("timestamp", mateInfo.getTimestamp().toString());
        ArrayList args = Lists.newArrayList((Object[])request.getArgs());
        try {
            params.put("md5", MD5.md5((String)JSONArray.toJSONString((Object)args)));
            return SignTool.sign(appSecret, params);
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hessianCoder(Object obj) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Hessian2Output hOut = new Hessian2Output((OutputStream)out);
        try {
            hOut.writeObject(obj);
            hOut.flush();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                hOut.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new SsoRunTimeException((Throwable)e);
            }
        }
        hOut.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object hessianDeCoder(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try (Hessian2Input hIn = new Hessian2Input((InputStream)in);){
            Object object = hIn.readObject();
            return object;
        }
    }
}

