/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.eventbus;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.eventbus.AsyncEvent;
import cn.com.duiba.sso.api.service.eventbus.BizEventListener;
import cn.com.duiba.sso.api.tool.ValidatorTool;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class SsoEventBus
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SsoEventBus.class);
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private ApplicationContext applicationContext;
    private EventBus eventBus = new EventBus();
    private AsyncEventBus asyncEventBus;
    private Set<String> listenerNameSet = Sets.newHashSet();

    public void register(Object listener) {
        if (Objects.equal(null, (Object)listener)) {
            return;
        }
        String listenerName = listener.getClass().getSimpleName();
        this.listenerNameSet.add(listenerName);
        this.eventBus.register(listener);
        this.asyncEventBus.register(listener);
        log.info(listenerName + "\u6ce8\u518c\u5230\u4e8b\u4ef6\u603b\u7ebf");
    }

    public void post(Object event) {
        try {
            ValidatorTool.valid(event);
            AsyncEvent annotation = (AsyncEvent)AnnotationUtils.findAnnotation(event.getClass(), AsyncEvent.class);
            if (annotation != null) {
                this.asyncEventBus.post(event);
            } else {
                this.eventBus.post(event);
            }
        }
        catch (Exception e) {
            log.error("\u4e8b\u4ef6\u53d1\u5e03\u5931\u8d25,\u4e8b\u4ef6\u7c7b\u578b:" + event.getClass().getSimpleName(), (Throwable)e);
            throw new SsoRunTimeException(e.getMessage());
        }
    }

    public String showAllListener() {
        Joiner joiner = Joiner.on((String)",").skipNulls();
        return joiner.join(this.listenerNameSet);
    }

    public void afterPropertiesSet() throws Exception {
        this.asyncEventBus = new AsyncEventBus((Executor)this.executorService);
        Collection objects = this.applicationContext.getBeansWithAnnotation(BizEventListener.class).values();
        for (Object listener : objects) {
            this.register(listener);
        }
    }
}

