/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.export;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.export.BaseExportRunnable;
import cn.com.duiba.sso.api.service.export.ExportFileInfo;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SsoExportFileService
implements ApplicationContextAware {
    private static final String EXPORT_FILE_TESK_NAME = "EXPORT_FILE_TESK_NAME";
    private static final Joiner KEY_JOINER = Joiner.on((String)"_").skipNulls();
    private ApplicationContext applicationContext;
    private static final String FILE_PATH = "tempFiles/";
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private ExecutorService executorService;

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    protected StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public ExportFileInfo getExportFileInfo(Long taskId) {
        String key = this.getTaskKey(taskId);
        if (this.stringRedisTemplate == null) {
            throw new SsoRunTimeException("\u9700\u8981\u5f80SsoExportFileService\u4e2dsetStringRedisTemplate\u624d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd");
        }
        ExportFileInfo info = new ExportFileInfo();
        if (!this.stringRedisTemplate.hasKey((Object)key).booleanValue()) {
            return info;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)key);
        Map map = operations.entries();
        info.setTaskId(taskId);
        info.setMessage((String)map.get("message"));
        info.setCount(Integer.valueOf((String)map.get("count")));
        info.setSuccessCount(Integer.valueOf((String)map.get("successCount")));
        info.setFileName((String)map.get("fileName"));
        info.setSuccess(Boolean.valueOf((String)map.get("success")));
        info.setUrl((String)map.get("url"));
        return info;
    }

    public <T extends BaseExportRunnable> T createExportTask(Class<T> teskType) {
        if (this.stringRedisTemplate == null) {
            throw new SsoRunTimeException("\u9700\u8981\u5f80SsoExportFileService\u4e2dsetStringRedisTemplate\u624d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd");
        }
        return (T)((BaseExportRunnable)this.applicationContext.getBean(teskType));
    }

    public void runTesk(BaseExportRunnable runnable) {
        this.executorService.submit(runnable);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected String getTaskKey(Long taskId) {
        return KEY_JOINER.join((Object)EXPORT_FILE_TESK_NAME, (Object)taskId, new Object[0]);
    }

    public File getTempDir() {
        String webRootDir = System.getProperty("user.home");
        File userDir = new File(webRootDir, FILE_PATH);
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        return userDir;
    }
}

