/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.mappingmode.SsoInterfaceManager;
import cn.com.duiba.sso.api.mappingmode.SsoMappingModePlugin;
import cn.com.duiba.sso.api.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.service.power.AdminPowerService;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.SystemInfo;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@EnableConfigurationProperties(value={SpringApplicationProperties.class, SsoBasicProperties.class})
@ComponentScan(value={"cn.com.duiba.sso.api"})
@ImportResource(value={"classpath:sso-common-task.xml"})
public class SsoBasicConfiguration {
    @Resource
    private SsoBasicProperties ssoBasicProperties;

    @Bean
    public SystemInfo initSysytem() {
        return new SystemInfo();
    }

    @Bean
    @ConditionalOnProperty(name={"duiba.sso.mapping-mode"}, havingValue="true", matchIfMissing=false)
    public SsoMappingModePlugin openSsoMappingMode() {
        if (StringUtils.isBlank((String)this.ssoBasicProperties.getAppSecret())) {
            throw new SsoRunTimeException("\u542f\u52a8SSO\u6620\u5c04\u6a21\u5f0f\u5fc5\u987b\u914d\u7f6eduiba.sso.app-secret");
        }
        return new SsoMappingModePlugin();
    }

    @Bean
    public SsoInterfaceManager ssoMappingModeHttpClient() {
        return new SsoInterfaceManager();
    }

    @Bean
    public SsoSystemService ssoSystemService() {
        return new SsoSystemService();
    }

    @Bean
    public PowerTreeService powerTreeService() {
        return new PowerTreeService();
    }

    @Bean
    public AdminPowerService adminPowerService() {
        return new AdminPowerService();
    }

    @Bean
    public SsoLoggerService ssoLoggerService() {
        return new SsoLoggerService();
    }

    @Bean
    public SsoEventBus ssoEventBus() {
        return new SsoEventBus();
    }
}

