/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.mappingmode;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.mappingmode.MappingModeRequest;
import cn.com.duiba.sso.api.mappingmode.MappingModeRequestMateInfo;
import cn.com.duiba.sso.api.mappingmode.MappingModeResponce;
import cn.com.duiba.sso.api.mappingmode.SsoInterfaceManager;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.remoteservice.SsoInterface;
import cn.com.duiba.sso.api.tool.SystemInfo;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class SsoMappingModePlugin {
    @Autowired
    private SsoInterfaceManager interfaceManager;
    @Autowired
    private SsoBasicProperties ssoBasicProperties;

    @Around(value="execution(* cn.com.duiba.sso.api.remoteservice.*.*(..))")
    public Object mappingModeRoute(ProceedingJoinPoint joinPoint) throws Throwable {
        if (StringUtils.equals((String)"sso-service", (String)SystemInfo.getSystemAlias())) {
            return joinPoint.proceed();
        }
        if (!this.ssoBasicProperties.getMappingMode().booleanValue()) {
            return joinPoint.proceed();
        }
        Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        Object target = joinPoint.getTarget();
        SsoInterface ssoInterface = (SsoInterface)AnnotationUtils.findAnnotation(target.getClass(), SsoInterface.class);
        if (ssoInterface == null) {
            return joinPoint.proceed();
        }
        Class remoteInterface = ssoInterface.value();
        MappingModeRequestMateInfo mateInfo = new MappingModeRequestMateInfo();
        mateInfo.setSystemName(SystemInfo.getSystemAlias());
        mateInfo.setInterfaceName(remoteInterface.getName());
        mateInfo.setMethod(method.getName());
        mateInfo.setTimestamp(System.currentTimeMillis());
        MappingModeRequest request = new MappingModeRequest();
        request.setMateInfo(mateInfo);
        request.setArgs(args);
        mateInfo.setSign(this.interfaceManager.createSign(this.ssoBasicProperties.getAppSecret(), request));
        MappingModeResponce responce = this.interfaceManager.mappingRequest(request);
        if (responce.getHasError().booleanValue()) {
            throw new SsoException(responce.getMessage());
        }
        return responce.getResult();
    }
}

