/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.SsoVersion;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class SystemInfo {
    private Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private static RemoteSystemService remoteSystemService;
    private static volatile String systemAlias;
    private static SsoSystemService ssoSystemService;

    @EventListener(value={MainContextRefreshedEvent.class})
    public void MainContextRefreshedEventListener() {
        try {
            SystemDto systemDto = ssoSystemService.getSystemByAlias(systemAlias);
            if (Objects.equals(systemDto, null)) {
                throw new SsoRunTimeException("\u672a\u627e\u5230" + systemAlias + "\u5bf9\u5e94\u7684\u7cfb\u7edf");
            }
            String version = SsoVersion.getVersion();
            if (StringUtils.isNotBlank((CharSequence)version)) {
                remoteSystemService.submitSsoVersion(systemDto.getId(), version);
            }
        }
        catch (Exception e) {
            this.logger.error("SSO\u6a21\u5757\u542f\u52a8\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    public static SystemDto getThisSystemInfo() {
        return ssoSystemService.getSystemByAlias(systemAlias);
    }

    public static Long getThisSystemId() {
        return SystemInfo.getThisSystemInfo().getId();
    }

    @Autowired
    public void setRemoteSystemService(RemoteSystemService remoteSystemService) {
        SystemInfo.remoteSystemService = remoteSystemService;
    }

    @Autowired
    public void setSpringApplicationProperties(SpringApplicationProperties springApplicationProperties) {
        systemAlias = Optional.ofNullable(springApplicationProperties.getPriorName()).orElse(springApplicationProperties.getName());
        if (StringUtils.isBlank((CharSequence)systemAlias)) {
            throw new SsoRunTimeException("Sso\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e spring.application.name \u7cfb\u7edf\u522b\u540d");
        }
    }

    @Autowired
    public void setSsoSystemService(SsoSystemService ssoSystemService) {
        SystemInfo.ssoSystemService = ssoSystemService;
    }

    public static String getSystemAlias() {
        return systemAlias;
    }
}

