package cn.com.duiba.sso.api.tool;


public final class SsoVersion {

    private SsoVersion() {
    }

    /**
     * Return the full version string of the present Spring Boot codebase, or {@code null}
     * if it cannot be determined.
     * @return the version of Spring Boot or {@code null}
     * @see Package#getImplementationVersion()
     */
    public static String getVersion() {
        Package pkg = SsoVersion.class.getPackage();
        return (pkg != null ? pkg.getImplementationVersion() : null);
    }

}
