package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.concurrent.TimeUnit;

public class SsoSystemService {

    private static final String SSO_SERVER_NAME = "sso-service";

    private Logger logger = LoggerFactory.getLogger(SsoSystemService.class);

    @Autowired
    private RemoteSystemService remoteSystemService;
    @Autowired
    private SsoBasicProperties ssoBasicProperties;

    private LoadingCache<String, SystemDto> cache = Caffeine.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build((systemName)->{
                SystemDto systemDto = remoteSystemService.getSystemByAlias(systemName);
                if(systemDto==null){
                    logger.error("systemName:"+systemName+"没有对应的系统配置");
                }
                return systemDto;
            });

    public SystemDto getSystemByAlias(String systemAlias){
        return cache.get(systemAlias);
    }

    public String getSsoHomeUrl(){
        return getSystemByAlias(SSO_SERVER_NAME).getHomeUrl();
    }

}
