package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.LeavePersonalDto;
import cn.com.duiba.sso.api.domain.dto.SeatDeptDto;
import cn.com.duiba.sso.api.domain.params.EntryParams;

import java.util.List;

/**
 * 人事
 */
@AdvancedFeignClient
public interface RemotePersonalService {

    /**
     * 获取所有离职员工的基本信息
     */
    List<LeavePersonalDto> getAllLeavePersonal();

    /**
     * 根据员工名称创建一个账号名
     * @param adminName 员工姓名
     * @return 账号
     */
    String createAccount(String adminName);

    /**
     * 入职
     * @param entryParams 入职申请
     * @return 员工Id
     */
    Long entry(EntryParams entryParams) throws BizException;

    /**
     * 离职
     * @param adminId 员工Id
     * @throws BizException 员工存在某种职权的绑定，需要解除才能进行离职
     */
    void dimission(Long adminId) throws BizException;

    /**
     * 由adminId获取该用户admin信息
     * @param id
     * @return
     */
    AdminDto findOneAdmin(Long id);

    /**
     * 用户修改个人信息时，更新位置信息和部门信息
     * @param seatDeptDto
     */
    void updateSeatDept(SeatDeptDto seatDeptDto);

}
