/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.sso.api.common.tree.Tree;
import cn.com.duiba.sso.api.common.tree.TreeFactory;
import cn.com.duiba.sso.api.common.tree.TreeView;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class PowerTreeCache {
    private final Tree<PowerDto> powerTree;
    private final Long version = new Date().getTime();
    private final HashMultimap<String, Long> urlMap;

    PowerTreeCache(Tree<PowerDto> powerTree, HashMultimap<String, Long> urlMap) {
        this.powerTree = powerTree;
        this.urlMap = urlMap;
    }

    public Set<Long> getPowerIdsByUrl(String url) {
        return this.urlMap.get((Object)url);
    }

    public PowerDto getPower(Long powerId) {
        return this.powerTree.getNode(powerId);
    }

    public <T extends TreeView<T>> List<T> getPowerTree(Function<PowerDto, T> transform) {
        List<PowerDto> nodeList = this.powerTree.getTreeView();
        ArrayList list = Lists.newArrayList();
        for (PowerDto power : nodeList) {
            TreeView node = (TreeView)transform.apply(power);
            if (node.getId() == null || node.getParentId() == null) {
                throw new SsoRunTimeException("Function\u8f6c\u5316\u65b9\u6cd5\u5fc5\u987b\u5b8c\u6210Id\u548cparentId\u7684\u8f6c\u5316");
            }
            list.add(node);
        }
        Tree tree = TreeFactory.createTree(list);
        return TreeFactory.transformTree(tree);
    }

    public List<PowerDto> getPowerWay(Long powerId) {
        return this.powerTree.getOneWayView(powerId);
    }

    public Long getVersion() {
        return this.version;
    }
}

