package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.common.interfaces.AppInterfaceAnalysisConfiguration;
import cn.com.duiba.sso.api.domain.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.domain.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.mappingmode.SsoMappingModePlugin;
import cn.com.duiba.sso.api.mappingmode.SsoMappingModeSleathPlugin;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.service.power.AdminPowerService;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Span;
import org.springframework.context.annotation.*;

@Configuration
@EnableConfigurationProperties({SpringApplicationProperties.class,SsoBasicProperties.class})
@ComponentScan("cn.com.duiba.sso.api")
@ImportResource("classpath:sso-common-task.xml")
@Import({
        SsoEnvironmentConfiguration.class,
        AppInterfaceAnalysisConfiguration.class
})
public class SsoBasicConfiguration {


    @Configuration
    @ConditionalOnClass(Aspect.class)
    @ConditionalOnProperty(name="duiba.sso.mapping-mode", havingValue="true")
    public static class SsoMappingModeConfiguration{

        @Bean
        public SsoMappingModePlugin ssoMappingModePlugin(){
            return new SsoMappingModePlugin();
        }

        @Bean
        @ConditionalOnClass(Span.class)
        public SsoMappingModeSleathPlugin ssoMappingModeSleathPlugin(){
            return new SsoMappingModeSleathPlugin();
        }
    }

    @Bean
    public SsoSystemService ssoSystemService(){
        return new SsoSystemService();
    }

    @Bean
    public PowerTreeService powerTreeService(){
        return new PowerTreeService();
    }

    @Bean
    public AdminPowerService adminPowerService(){
        return new AdminPowerService();
    }

    @Bean
    public SsoLoggerService ssoLoggerService(){
        return new SsoLoggerService();
    }

}
