package cn.com.duiba.sso.api.tool;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.sso.api.common.interfaces.AppInterfaceAnalysisService;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.params.ApplicationInfoParams;
import cn.com.duiba.sso.api.domain.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.domain.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.Optional;

/**
 * Created by liuyao on 2017/12/5.
 * 本系统的Mate信息
 */
@Slf4j
public class SystemInfo{

    private volatile static String systemAlias;

    private static SsoSystemService ssoSystemService;

    private static RemoteSystemService remoteSystemService;
    @Autowired
    private SsoBasicProperties ssoBasicProperties;
    @Autowired
    private EnvironmentEnum defaultEnvironmentEnum;
    @Autowired
    private AppInterfaceAnalysisService appInterfaceAnalysisService;

    @EventListener(MainContextRefreshedEvent.class)
    public void MainContextRefreshedEventListener(){
        try{

            if(Objects.equals(defaultEnvironmentEnum,EnvironmentEnum.DEV)){
                 remoteSystemService.checkAppVersion(DuibaBootVersion.getVersion(),SsoVersion.getVersion());
            }

            String version = SsoVersion.getVersion();
            ApplicationInfoParams params = new ApplicationInfoParams();
            params.setAppName(systemAlias);
            params.setVersion(version);
            params.setHomeUrl(ssoBasicProperties.getHomeUrl());//即将废弃，统一域名后，不再以注册的方式向SSO提交域名
            params.setProfiles(defaultEnvironmentEnum.getName());

            remoteSystemService.submitApplicationInfoParams(params);

            appInterfaceAnalysisService.gatherAppInterfaceInfo();//采集接口信息
        }catch (Exception e){
            log.error("向SSO提交应用原数据失败",e);
        }
    }

    /**
     * 获取本系统的信息
     */
    public static SystemDto getThisSystemInfo(){
        return ssoSystemService.getSystemByAlias(systemAlias);
    }

    /**
     * 获取本系统的Id
     */
    public static Long getThisSystemId(){
        SystemDto system = getThisSystemInfo();
        if(system==null){
            throw new SsoRunTimeException("没有检索到"+systemAlias+"对应的系统配置");
        }
        return system.getId();
    }

    @Autowired
    public void setRemoteSystemService(RemoteSystemService remoteSystemService) {
        SystemInfo.remoteSystemService = remoteSystemService;//NOSONAR
    }
    @Autowired
    public void setSpringApplicationProperties(SpringApplicationProperties springApplicationProperties) {
        SystemInfo.systemAlias = Optional.ofNullable(springApplicationProperties.getPriorName()).orElse(springApplicationProperties.getName());//NOSONAR
        if (StringUtils.isBlank(systemAlias)){
            throw new SsoRunTimeException("Sso客户端启动失败，请配置 spring.application.name 系统别名");
        }
    }

    @Autowired
    public void setSsoSystemService(SsoSystemService ssoSystemService) {
        SystemInfo.ssoSystemService = ssoSystemService;//NOSONAR
    }

    public static String getSystemAlias(){
        return SystemInfo.systemAlias;
    }



}