package cn.com.duiba.sso.api.common.interfaces;

import cn.com.duiba.sso.api.common.interfaces.analysis.SsoLoggerMethodInfoAnalysis;
import cn.com.duiba.sso.api.common.interfaces.analysis.SwaggerMethodInfoAnalysis;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
public class AppInterfaceAnalysisConfiguration {

    @Bean
    public AppInterfaceAnalysisService appInterfaceAnalysisService(List<MethodInfoAnalysis> analyses){
        AppInterfaceAnalysisService service = new AppInterfaceAnalysisService();
        service.setAnalysisList(Lists.reverse(analyses));
        return service;
    }

    @Bean
    public SsoLoggerMethodInfoAnalysis ssoLoggerMethodInfoAnalysis(){
        return new SsoLoggerMethodInfoAnalysis();
    }

    @Configuration
    @ConditionalOnClass(ApiOperation.class)
    public static class SwaggerMethodInfoAnalysisConfiguration{

        @Bean
        public SwaggerMethodInfoAnalysis swaggerMethodInfoAnalysis(){
            return new SwaggerMethodInfoAnalysis();
        }

    }

}
