package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;

public class SignTool {

    private static final Logger log = LoggerFactory.getLogger(SignTool.class);

    private static final Set<String> IGNORE_KEYS = new HashSet<>();

    private static final Long TIME_OUT = 180000L;//签名3分钟之内有效

    static {
        IGNORE_KEYS.add("sign");
        IGNORE_KEYS.add("appSecret");
    }

    public static void signVerify(String appSecret, Map<String, String> params) {
        Map<String, String> map = new HashMap<>();
        Set<String> keys = params.keySet();
        for (String key : keys) {
            if (!IGNORE_KEYS.contains(key)) {
                map.put(key, params.get(key));
            }
        }
        String sign = sign(appSecret,map);
        if(!StringUtils.equals(sign,params.get("sign"))){
            throw new SsoRunTimeException("签名验证失败");
        }
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null)
            return "";
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    /**
     * @param params
     * @return
     */
    public static String sign(String appSecret,Map<String, String> params) {
        if(StringUtils.isBlank(appSecret)){
            throw new SsoRunTimeException("缺失秘钥");
        }
        if(!params.containsKey("timestamp")){
            throw new SsoRunTimeException("参数缺少时间戳");
        }

        Long timestamp = Long.valueOf(params.get("timestamp"));
        Long now = new Date().getTime();
        long def = now - timestamp;

        if(Math.abs(def)>TIME_OUT){
            throw new SsoRunTimeException("签名失效");
        }

        Map<String,String> sourceMap = Maps.newHashMap();
        sourceMap.put("appSecret", appSecret);
        sourceMap.putAll(params);

        List<String> keys = Lists.newArrayList(sourceMap.keySet());
        Collections.sort(keys);

        StringBuilder stringBuilder = new StringBuilder();
        for (String s : keys) {
            stringBuilder.append(sourceMap.get(s));
        }
        try {
            String src = stringBuilder.toString();
            return toHexValue(encryptMD5(src.getBytes("utf-8")));
        } catch (Exception e) {
            log.error("md5 error", e);
            throw new SsoRunTimeException(e);
        }
    }


    private static byte[] encryptMD5(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

}
