/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.common.interfaces;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.common.interfaces.MethodInfo;
import cn.com.duiba.sso.api.common.interfaces.MethodInfoAnalysis;
import cn.com.duiba.sso.api.domain.params.AppInterfaceInfoParams;
import cn.com.duiba.sso.api.domain.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.remoteservice.RemoteAppInterfaceInfoService;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class AppInterfaceAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(AppInterfaceAnalysisService.class);
    private Set<String> whitePackages = Sets.newHashSet();
    private static final Integer SUBMIT_LIMIT = 10;
    private Joiner joiner;
    private List<MethodInfoAnalysis> analysisList;
    @Resource(name="$ssoExecutorService")
    private ExecutorService executorService;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private RemoteAppInterfaceInfoService remoteAppInterfaceInfoService;
    @Resource
    private SpringApplicationProperties springApplicationProperties;

    public AppInterfaceAnalysisService() {
        this.whitePackages.add("org.springframework");
        this.whitePackages.add("springfox");
        this.whitePackages.add("cn.com.duiba.sso.ui");
        this.whitePackages.add("cn.com.duiba.sso.api");
        this.whitePackages.add("cn.com.duibaboot");
        this.joiner = Joiner.on((String)",").skipNulls();
    }

    public void gatherAppInterfaceInfo() {
        GatherAppInterfaceInfoRunnble runnble = new GatherAppInterfaceInfoRunnble();
        this.executorService.submit(runnble);
    }

    public List<AppInterfaceInfoParams> analysisCurrentAppInterface() {
        Map mappingMap = this.applicationContext.getBeansOfType(AbstractHandlerMethodMapping.class);
        Collection methodMappings = mappingMap.values();
        String[] whitePackagesArray = this.whitePackagesArray();
        ArrayList infoParams = Lists.newArrayList();
        for (AbstractHandlerMethodMapping mapping : methodMappings) {
            Map methods = mapping.getHandlerMethods();
            for (Map.Entry entry : methods.entrySet()) {
                HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
                String className = handlerMethod.getBeanType().getName();
                if (StringUtils.startsWithAny((String)className, (String[])whitePackagesArray)) continue;
                AppInterfaceInfoParams params = new AppInterfaceInfoParams();
                params.setController(className);
                params.setMethod(this.buildMethodName(handlerMethod));
                RequestMethodsRequestCondition methodsRequestCondition = requestMappingInfo.getMethodsCondition();
                params.setMethodTypes(methodsRequestCondition.getMethods().stream().map(Objects::toString).collect(Collectors.toSet()));
                PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
                params.setPaths(patternsRequestCondition.getPatterns());
                List<MethodInfo> infos = this.analysisList.stream().map(analysis -> analysis.analysis(handlerMethod)).collect(Collectors.toList());
                MethodInfo methodMateDate = this.mergeMethodInfo(infos);
                params.getMethodTypes().addAll(methodMateDate.getTypeSet());
                params.setInterfaceName(methodMateDate.getName());
                params.setInterfaceComment(methodMateDate.getComment());
                infoParams.add(params);
            }
        }
        return infoParams;
    }

    private MethodInfo mergeMethodInfo(List<MethodInfo> infos) {
        MethodInfo methodMateDate = new MethodInfo();
        for (MethodInfo info : infos) {
            if (Objects.isNull(info)) continue;
            if (StringUtils.isNotBlank((String)info.getName())) {
                methodMateDate.setName(info.getName());
            }
            if (StringUtils.isNotBlank((String)info.getComment())) {
                methodMateDate.setComment(info.getComment());
            }
            methodMateDate.getTypeSet().addAll(info.getTypeSet());
        }
        return methodMateDate;
    }

    private String[] whitePackagesArray() {
        String[] array = new String[this.whitePackages.size()];
        Lists.newArrayList(this.whitePackages).toArray(array);
        return array;
    }

    private String buildMethodName(HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(method.getName());
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        if (methodParameters.length == 0) {
            return stringBuilder.toString();
        }
        stringBuilder.append("(");
        ArrayList paramsInfos = Lists.newArrayList();
        for (MethodParameter parameter : methodParameters) {
            paramsInfos.add(parameter.getParameterType().getSimpleName());
        }
        stringBuilder.append(this.joiner.join((Iterable)paramsInfos));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected void setAnalysisList(List<MethodInfoAnalysis> analysisList) {
        this.analysisList = analysisList;
    }

    public void addExcludePackage(Set<String> packages) {
        this.whitePackages.addAll(packages);
    }

    private class GatherAppInterfaceInfoRunnble
    implements Runnable {
        private GatherAppInterfaceInfoRunnble() {
        }

        @Override
        public void run() {
            Long version;
            String appName = AppInterfaceAnalysisService.this.springApplicationProperties.getName();
            if (StringUtils.isBlank((String)appName)) {
                return;
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.info("\u4fe1\u606f\u91c7\u96c6\u88ab\u4e2d\u65ad", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            try {
                version = AppInterfaceAnalysisService.this.remoteAppInterfaceInfoService.tryBeginSubmitInterfaceInfo(appName);
            }
            catch (BizException e) {
                log.info("\u4fe1\u606f\u91c7\u96c6\u88ab\u62d2\u7edd", (Throwable)e);
                return;
            }
            List<AppInterfaceInfoParams> infoParamsList = AppInterfaceAnalysisService.this.analysisCurrentAppInterface();
            ArrayListMultimap multimap = ArrayListMultimap.create();
            for (int i = 0; i < infoParamsList.size(); ++i) {
                int key = i / SUBMIT_LIMIT;
                multimap.put((Object)key, (Object)infoParamsList.get(i));
            }
            int count = 0;
            try {
                for (Integer key : multimap.keySet()) {
                    try {
                        List list = multimap.get((Object)key);
                        count += AppInterfaceAnalysisService.this.remoteAppInterfaceInfoService.submitInterfaceInfo(appName, version, list).intValue();
                    }
                    catch (BizException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        log.error("\u63d0\u4ea4\u63a5\u53e3\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                    }
                }
                log.info("\u5171\u63d0\u4ea4", (Object)count);
                AppInterfaceAnalysisService.this.remoteAppInterfaceInfoService.endSubmit(appName, version);
            }
            catch (BizException e) {
                log.info("\u63d0\u4ea4\u63a5\u53e3\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                AppInterfaceAnalysisService.this.remoteAppInterfaceInfoService.rollback(appName, version);
            }
        }
    }
}

