/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum EnvironmentEnum {
    DEV(1L, "dev", "\u5f00\u53d1\u73af\u5883"),
    TEST(2L, "test", "\u6d4b\u8bd5\u73af\u5883"),
    ALI_TEST(2L, "test01", "\u963f\u91cc\u6d4b\u8bd5\u73af\u5883"),
    PRE(3L, "pre", "\u9884\u53d1\u73af\u5883"),
    PROD(3L, "prod", "\u751f\u4ea7\u73af\u5883");

    private final Long envId;
    private final String name;
    private final String envName;

    private EnvironmentEnum(Long envId, String name, String envName) {
        this.envId = envId;
        this.name = name;
        this.envName = envName;
    }

    public Long getEnvId() {
        return this.envId;
    }

    public String getName() {
        return this.name;
    }

    public String getEnvName() {
        return this.envName;
    }

    public static EnvironmentEnum getEnvByName(String name) {
        Objects.requireNonNull(name);
        switch (name) {
            case "dev": {
                return DEV;
            }
            case "test": {
                return TEST;
            }
            case "prod": {
                return PROD;
            }
            case "pre": {
                return PRE;
            }
        }
        throw new SsoRunTimeException("\u73af\u5883\u53d8\u91cf\u89e3\u6790\u5931\u8d25");
    }

    public static EnvironmentEnum getEnvById(Long id) {
        switch (id.intValue()) {
            case 1: {
                return DEV;
            }
            case 2: {
                return TEST;
            }
            case 3: {
                return PROD;
            }
        }
        throw new SsoRunTimeException("\u73af\u5883\u53d8\u91cf\u89e3\u6790\u5931\u8d25");
    }

    public static EnvironmentEnum getEnvByPrefix(String prefix) {
        for (EnvironmentEnum env : EnvironmentEnum.values()) {
            if (!StringUtils.startsWith((String)prefix, (String)env.getName())) continue;
            return env;
        }
        return null;
    }

    public static Boolean isOnline(EnvironmentEnum environment) {
        return Objects.equals((Object)environment, (Object)PROD) || Objects.equals((Object)environment, (Object)PRE);
    }

    public static EnvironmentEnum parseEnvironmentEnum(String profiles) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)profiles)) {
            return PROD;
        }
        for (EnvironmentEnum environmentEnum : EnvironmentEnum.values()) {
            if (!StringUtils.startsWith((String)profiles, (String)environmentEnum.getName())) continue;
            return environmentEnum;
        }
        return PROD;
    }
}

